VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "mscomctl.ocx"
Begin VB.Form frmDPC_BOM 
   Caption         =   "#Material search"
   ClientHeight    =   9705
   ClientLeft      =   120
   ClientTop       =   450
   ClientWidth     =   14235
   ControlBox      =   0   'False
   LinkTopic       =   "Form2"
   ScaleHeight     =   9705
   ScaleWidth      =   14235
   StartUpPosition =   3  'Windows Default
   Tag             =   "frmDPC_BOM"
   Visible         =   0   'False
   Begin MSComctlLib.TabStrip tbs_Filter 
      Height          =   375
      Left            =   45
      TabIndex        =   5
      Tag             =   "tbs_Filter"
      Top             =   1305
      Width           =   14040
      _ExtentX        =   24765
      _ExtentY        =   661
      _Version        =   393216
      BeginProperty Tabs {1EFB6598-857C-11D1-B16A-00C0F0283628} 
         NumTabs         =   7
         BeginProperty Tab1 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#All"
            Key             =   "tbs_All"
            Object.Tag             =   "tbs_All"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab2 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Coil"
            Key             =   "tbs_Coil"
            Object.Tag             =   "tbs_Coil"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab3 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Sheet Metal"
            Key             =   "tbs_SheetMetal"
            Object.Tag             =   "tbs_SheetMetal"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab4 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Gasket/Spacer"
            Key             =   "tbs_Gasket"
            Object.Tag             =   "tbs_Gasket"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab5 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Coating"
            Key             =   "tbs_Coating"
            Object.Tag             =   "tbs_Coating"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab6 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Inlay"
            Key             =   "tbs_Inlay"
            Object.Tag             =   "tbs_Inlay"
            ImageVarType    =   2
         EndProperty
         BeginProperty Tab7 {1EFB659A-857C-11D1-B16A-00C0F0283628} 
            Caption         =   "#Packaging"
            Key             =   "tbs_Packaging"
            Object.Tag             =   "tbs_Packaging"
            ImageVarType    =   2
         EndProperty
      EndProperty
   End
   Begin Project1.ToolbarControl tlb_Main 
      Height          =   690
      Left            =   45
      TabIndex        =   0
      Tag             =   "2910"
      Top             =   45
      Width           =   14070
      _ExtentX        =   24818
      _ExtentY        =   1217
   End
   Begin Project1.ArmGrid grd_Material 
      Height          =   5760
      Left            =   60
      TabIndex        =   34
      Tag             =   "grd_Material"
      Top             =   3945
      Width           =   14130
      _ExtentX        =   24924
      _ExtentY        =   10160
   End
   Begin VB.Frame fra_Article 
      Height          =   600
      Left            =   60
      TabIndex        =   1
      Tag             =   "fra_Filter"
      Top             =   705
      Width           =   14055
      Begin VB.TextBox txt_Textbox 
         Height          =   330
         Index           =   2
         Left            =   9195
         TabIndex        =   4
         Tag             =   "txt_Desc"
         Top             =   180
         Width           =   3705
      End
      Begin VB.TextBox txt_Textbox 
         Height          =   330
         Index           =   1
         Left            =   3855
         TabIndex        =   3
         Tag             =   "txt_Name"
         Top             =   180
         Width           =   3705
      End
      Begin VB.TextBox txt_Textbox 
         Height          =   330
         Index           =   0
         Left            =   1005
         TabIndex        =   2
         Tag             =   "txt_IdentNr"
         Top             =   180
         Width           =   1485
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Desc"
         Height          =   270
         Index           =   7
         Left            =   7935
         TabIndex        =   37
         Tag             =   "lbl_RawMatDesc"
         Top             =   210
         Width           =   1200
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Name"
         Height          =   270
         Index           =   4
         Left            =   2595
         TabIndex        =   36
         Tag             =   "lbl_RawMatName"
         Top             =   210
         Width           =   1200
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Ident Nr"
         Height          =   270
         Index           =   0
         Left            =   180
         TabIndex        =   35
         Tag             =   "lbl_IdentNr"
         Top             =   210
         Width           =   1200
      End
   End
   Begin VB.Frame fra_FilterMain 
      Height          =   2280
      Left            =   30
      TabIndex        =   6
      Tag             =   "fra_FilterMain"
      Top             =   1650
      Width           =   14070
      Begin VB.Frame fra_Filter 
         Height          =   615
         Index           =   6
         Left            =   11340
         TabIndex        =   32
         Tag             =   "fra_FilterArticleGroup"
         Top             =   750
         Width           =   2625
         Begin VB.TextBox txt_Textbox 
            Height          =   300
            Index           =   10
            Left            =   1620
            TabIndex        =   33
            Tag             =   "txt_ArticleGroup"
            Top             =   195
            Width           =   900
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Article group"
            Height          =   270
            Index           =   10
            Left            =   105
            TabIndex        =   46
            Tag             =   "lbl_ArticleGroup"
            Top             =   210
            Width           =   1410
         End
      End
      Begin VB.Frame fra_Filter 
         Height          =   615
         Index           =   5
         Left            =   9120
         TabIndex        =   14
         Tag             =   "fra_FilterInlayCode"
         Top             =   120
         Width           =   2205
         Begin VB.TextBox txt_Textbox 
            Height          =   300
            Index           =   7
            Left            =   1200
            TabIndex        =   15
            Tag             =   "txt_InlayCode"
            Top             =   195
            Width           =   900
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#SML Code"
            Height          =   270
            Index           =   9
            Left            =   120
            TabIndex        =   45
            Tag             =   "lbl_SMLCode"
            Top             =   210
            Width           =   945
         End
      End
      Begin VB.Frame fra_Filter 
         Height          =   615
         Index           =   4
         Left            =   6870
         TabIndex        =   12
         Tag             =   "fra_FilterLength"
         Top             =   120
         Width           =   2205
         Begin VB.TextBox txt_Textbox 
            Height          =   300
            Index           =   6
            Left            =   1200
            TabIndex        =   13
            Tag             =   "txt_Length"
            Top             =   195
            Width           =   900
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Length"
            Height          =   270
            Index           =   5
            Left            =   120
            TabIndex        =   44
            Tag             =   "lbl_Length"
            Top             =   210
            Width           =   945
         End
      End
      Begin VB.Frame fra_Filter 
         Height          =   615
         Index           =   3
         Left            =   4620
         TabIndex        =   10
         Tag             =   "fra_FilterWidth"
         Top             =   120
         Width           =   2205
         Begin VB.TextBox txt_Textbox 
            Height          =   300
            Index           =   5
            Left            =   1200
            TabIndex        =   11
            Tag             =   "txt_Width"
            Top             =   195
            Width           =   900
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Width"
            Height          =   270
            Index           =   3
            Left            =   135
            TabIndex        =   43
            Tag             =   "lbl_Width"
            Top             =   225
            Width           =   960
         End
      End
      Begin VB.Frame fra_Filter 
         Height          =   615
         Index           =   2
         Left            =   45
         TabIndex        =   7
         Tag             =   "fra_FilterCoil"
         Top             =   120
         Width           =   4515
         Begin VB.TextBox txt_Textbox 
            Height          =   300
            Index           =   4
            Left            =   3720
            TabIndex        =   9
            Tag             =   "txt_CoilThickness"
            Top             =   210
            Width           =   720
         End
         Begin VB.TextBox txt_Textbox 
            Height          =   300
            Index           =   3
            Left            =   1065
            TabIndex        =   8
            Tag             =   "txt_CoilMaterial"
            Top             =   210
            Width           =   1500
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Thickness"
            Height          =   270
            Index           =   2
            Left            =   2640
            TabIndex        =   42
            Tag             =   "lbl_CoilThickness"
            Top             =   225
            Width           =   1080
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Material"
            Height          =   270
            Index           =   1
            Left            =   105
            TabIndex        =   41
            Tag             =   "lbl_CoilMaterial"
            Top             =   225
            Width           =   930
         End
      End
      Begin VB.Frame fra_Filter 
         Height          =   615
         Index           =   1
         Left            =   11340
         TabIndex        =   16
         Tag             =   "fra_FilterLagerbest"
         Top             =   120
         Width           =   2625
         Begin VB.TextBox txt_Textbox 
            Height          =   300
            Index           =   8
            Left            =   1620
            TabIndex        =   17
            Tag             =   "txt_Lagerbest"
            Top             =   195
            Width           =   900
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Lagerbest"
            Height          =   270
            Index           =   8
            Left            =   105
            TabIndex        =   40
            Tag             =   "lbl_Lagerbest"
            Top             =   210
            Width           =   1410
         End
      End
      Begin VB.Frame fra_Filter 
         Height          =   1515
         Index           =   0
         Left            =   60
         TabIndex        =   38
         Tag             =   "fra_FilterCoating"
         Top             =   705
         Width           =   9030
         Begin VB.Frame fra_CoatingApplication 
            Caption         =   "#Application"
            Height          =   1335
            Left            =   60
            TabIndex        =   18
            Tag             =   "fra_CoatingApplication"
            Top             =   120
            Width           =   1995
            Begin VB.OptionButton opt_CoatingApp 
               Caption         =   "#All"
               Height          =   285
               Index           =   0
               Left            =   105
               TabIndex        =   19
               Tag             =   "opt_CoatingAppAll"
               Top             =   225
               Value           =   -1  'True
               Width           =   1815
            End
            Begin VB.OptionButton opt_CoatingApp 
               Caption         =   "#Inside"
               Height          =   285
               Index           =   1
               Left            =   105
               TabIndex        =   20
               Tag             =   "opt_CoatingAppInside"
               Top             =   495
               Width           =   1815
            End
            Begin VB.OptionButton opt_CoatingApp 
               Caption         =   "#Outside"
               Height          =   285
               Index           =   2
               Left            =   105
               TabIndex        =   21
               Tag             =   "opt_CoatingAppOutside"
               Top             =   765
               Width           =   1815
            End
         End
         Begin VB.Frame fra_CoatingType 
            Caption         =   "#Type"
            Height          =   1350
            Left            =   2085
            TabIndex        =   22
            Tag             =   "fra_CoatingType"
            Top             =   120
            Width           =   2940
            Begin VB.OptionButton opt_CoatingType 
               Caption         =   "#Powder thin film"
               Height          =   285
               Index           =   2
               Left            =   120
               TabIndex        =   25
               Tag             =   "opt_CoatingTypePowderThin"
               Top             =   750
               Width           =   2775
            End
            Begin VB.OptionButton opt_CoatingType 
               Caption         =   "#Powder"
               Height          =   285
               Index           =   1
               Left            =   120
               TabIndex        =   24
               Tag             =   "opt_CoatingTypePowder"
               Top             =   465
               Width           =   2775
            End
            Begin VB.OptionButton opt_CoatingType 
               Caption         =   "#All"
               Height          =   285
               Index           =   0
               Left            =   120
               TabIndex        =   23
               Tag             =   "opt_CoatingTypeAll"
               Top             =   210
               Value           =   -1  'True
               Width           =   2775
            End
            Begin VB.OptionButton opt_CoatingType 
               Caption         =   "#Paint"
               Height          =   285
               Index           =   3
               Left            =   120
               TabIndex        =   26
               Tag             =   "opt_CoatingTypePaint"
               Top             =   1020
               Width           =   2775
            End
         End
         Begin VB.TextBox txt_Textbox 
            Height          =   330
            Index           =   9
            Left            =   8010
            TabIndex        =   31
            Tag             =   "txt_CoatingNormNr"
            Top             =   210
            Width           =   915
         End
         Begin VB.Frame fra_ColorType 
            Caption         =   "#Color"
            Height          =   1350
            Left            =   5070
            TabIndex        =   27
            Tag             =   "fra_ColorType"
            Top             =   120
            Width           =   1710
            Begin VB.OptionButton opt_ColorNorm 
               Caption         =   "#All"
               Height          =   285
               Index           =   0
               Left            =   120
               TabIndex        =   28
               Tag             =   "opt_ColorNormAll"
               Top             =   240
               Value           =   -1  'True
               Width           =   1275
            End
            Begin VB.OptionButton opt_ColorNorm 
               Caption         =   "#RAL"
               Height          =   285
               Index           =   1
               Left            =   120
               TabIndex        =   29
               Tag             =   "opt_ColorNormRAL"
               Top             =   510
               Width           =   1275
            End
            Begin VB.OptionButton opt_ColorNorm 
               Caption         =   "#NCS"
               Height          =   285
               Index           =   2
               Left            =   120
               TabIndex        =   30
               Tag             =   "opt_ColorNormNCS"
               Top             =   810
               Width           =   1275
            End
         End
         Begin VB.Label lbl_Label 
            Caption         =   "#Color Nr"
            Height          =   270
            Index           =   6
            Left            =   6930
            TabIndex        =   39
            Tag             =   "lbl_CoatingNr"
            Top             =   255
            Width           =   990
         End
      End
   End
End
Attribute VB_Name = "frmDPC_BOM"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SCREEN_NAME As String = "frmDPC_BOM"
Private Const SW_SHOWNORMAL = 1

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const LOCALE_USER_DEFAULT = &H400
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MSG_ID_BASE As Long = 9700

#If ENV = LIVE Then
Private mo_Sys As Object
Private mo_Db As Object
Private mo_DbBaeurer As Object
Private mo_FSO As Object
#Else
Private mo_Sys As ARMSYSCOMLib.ArmSYS
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_DbBaeurer As ARMSYSCOMLib.ArmDb
Private mo_FSO As Scripting.FileSystemObject
#End If

Private mo_Tools As DPC_Tools

Private ml_U_Code As Long
Private mb_Initialized As Boolean
Private ms_DecimalSeparator As String
Private ms_ThousandSeparator As String
Private mc_ScreenLabels As Long
Private mc_Toolbars As Long
Private mo_WshNetwork As Object
Private ms_ComputerName As String
Private ms_Language_Code                As String       'current user interface language
Private ms_LoginName                    As String       'contain loginname
Private ms_UserName                     As String       'contain name of logged user as defined in GEN_People
Private mb_Result As Boolean
Private ms_IdentNr As String
Private ms_IdentName As String
Private mb_InternalInit As Boolean
Private me_Material As eDPCBOMMaterial
Private mo_BOM As DPC_BOM
Private mla_OrigColWidth() As Long

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Public Property Set ArmDbBaeurer(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_DbBaeurer = lo_Db
  End If
End Property

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Public Property Set BOM(ByRef ao_BOM As DPC_BOM)
On Error GoTo ErrorHandler

  Set mo_BOM = ao_BOM
  Exit Property
ErrorHandler:
  Call ErrorHandler("BOM.Set")
End Property

Property Let Categ(ae_Material As eDPCBOMMaterial)
  me_Material = ae_Material
End Property

Property Get Categ() As eDPCBOMMaterial
  Categ = me_Material
End Property

Public Property Get IdentNr() As String

  IdentNr = ms_IdentNr
End Property

Public Property Get IdentName() As String

  IdentName = ms_IdentName
End Property

Public Property Get Result() As Boolean
  Result = mb_Result
End Property

Public Property Let FilterEnabled(ByVal ab_Value As Boolean)

  tbs_Filter.Enabled = ab_Value
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Function Load_A_COM() As Boolean
On Error GoTo ErrHandler

Dim la_Columns As Variant
Dim ll_Idx As Long

  Load_A_COM = False
  
  If mb_Initialized Then
      Call Err.Raise(ArmErr.CPTAlreadyInitialized)
  End If
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If

  mb_InternalInit = False
  
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  ms_ThousandSeparator = mo_Tools.GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND)
  ms_DecimalSeparator = Format(0, ".")
  mc_ScreenLabels = 0
  mc_Toolbars = 0
  
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
#If ENV = LIVE Then
  Set mo_Sys = CreateObject("ArmSYSCOM.ArmSys")
#Else
  Set mo_Sys = New ARMSYSCOMLib.ArmSYS
#End If
  
  Set mo_WshNetwork = CreateObject("WScript.Network")
  ms_ComputerName = mo_WshNetwork.ComputerName
  
  Set grd_Material.ArmDb = mo_DbBaeurer
  ReDim la_Columns(14) As Variant
  la_Columns(0) = "lgnr" & CH_LDELIMIT & "400" & CH_LDELIMIT & "0" & CH_LDELIMIT & "lgnr" & CH_LDELIMIT & "#Lg Nr"
  la_Columns(1) = "identnr" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "1" & CH_LDELIMIT & "identnr" & CH_LDELIMIT & "#Ident Nr"
  la_Columns(2) = "ben" & CH_LDELIMIT & "2000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ben" & CH_LDELIMIT & "#Name" & CH_LDELIMIT & "STRING"
  la_Columns(3) = "ben1" & CH_LDELIMIT & "1500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "ben1" & CH_LDELIMIT & "#Desc" & CH_LDELIMIT & "STRING"
  la_Columns(4) = "werkstoff" & CH_LDELIMIT & "1000" & CH_LDELIMIT & "0" & CH_LDELIMIT & "werkstoff" & CH_LDELIMIT & "#Material" & CH_LDELIMIT & "STRING"
  la_Columns(5) = "InlayCode" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "InlayCode" & CH_LDELIMIT & "#SMLCode" & CH_LDELIMIT & "STRING"
  la_Columns(6) = "norm" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "norm" & CH_LDELIMIT & "#Norm" & CH_LDELIMIT & "STRING"
  la_Columns(7) = "klasse" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "klasse" & CH_LDELIMIT & "#Class" & CH_LDELIMIT & "STRING"
  la_Columns(8) = "StandardCoil" & CH_LDELIMIT & "500" & CH_LDELIMIT & "0" & CH_LDELIMIT & "StandardCoil" & CH_LDELIMIT & "#Std.coil" & CH_LDELIMIT & "STRING"
  la_Columns(9) = "lamenge" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "lamenge" & CH_LDELIMIT & "#Lagerbest." & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "0.00"
  la_Columns(10) = "bestell" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "bestell" & CH_LDELIMIT & "#Bestellbest" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "0.00"
  la_Columns(11) = "vormerk" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "vormerk" & CH_LDELIMIT & "#Vormerk" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "0.00"
  la_Columns(12) = "verfugbar" & CH_LDELIMIT & "1100" & CH_LDELIMIT & "0" & CH_LDELIMIT & "verfugbar" & CH_LDELIMIT & "#Verfugbar" & CH_LDELIMIT & "FLOAT" & CH_LDELIMIT & "0.00"
  la_Columns(13) = "me" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "me" & CH_LDELIMIT & "#UoM"
  la_Columns(14) = "Price" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Price" & CH_LDELIMIT & "#Price"
  'la_Columns(5) = "Length" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "CutLength" & CH_LDELIMIT & "#Cut length"
  'la_Columns(6) = "Width" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "CutWidth" & CH_LDELIMIT & "#Cut width"
  'la_Columns(7) = "Thickness" & CH_LDELIMIT & "800" & CH_LDELIMIT & "0" & CH_LDELIMIT & "Thickness" & CH_LDELIMIT & "#Thickness"
  Call grd_Material.SetColumns(la_Columns)
  ReDim mla_OrigColWidth(grd_Material.Cols - 1)
  For ll_Idx = 0 To grd_Material.Cols - 1
    mla_OrigColWidth(ll_Idx) = grd_Material.Columns(ll_Idx).Width
  Next
  'Call tlb_Main.SetToolbarInfoStringParameters("001EE01760QESFGIDR/BACAHHFLLSTT", "001")
  'Call tlb_Main.DisplayFace("0")
  'tlb_Main.Visible = True

  ms_IdentNr = ""
  ms_IdentName = ""
  
  Call mo_Tools.LoadToolbars(mo_Db, Me.Controls, "DPC", SCREEN_NAME)
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, gl_CodePage, gl_CodePage, Me)
  
  Call Resize
  
  If me_Material = eDPCBOMMaterial.bcCoil Then
    Set tbs_Filter.SelectedItem = tbs_Filter.Tabs("tbs_Coil")
  ElseIf me_Material = eDPCBOMMaterial.bcSheetMetal Then
    Set tbs_Filter.SelectedItem = tbs_Filter.Tabs("tbs_SheetMetal")
  ElseIf me_Material = eDPCBOMMaterial.bcGasket Then
    Set tbs_Filter.SelectedItem = tbs_Filter.Tabs("tbs_Gasket")
  ElseIf me_Material = eDPCBOMMaterial.bcCoating Then
    Set tbs_Filter.SelectedItem = tbs_Filter.Tabs("tbs_Coating")
  ElseIf me_Material = eDPCBOMMaterial.bcInlay Then
    Set tbs_Filter.SelectedItem = tbs_Filter.Tabs("tbs_Inlay")
  ElseIf me_Material = eDPCBOMMaterial.bcPacking Then
    Set tbs_Filter.SelectedItem = tbs_Filter.Tabs("tbs_Packaging")
  Else
    Set tbs_Filter.SelectedItem = tbs_Filter.Tabs("tbs_All")
  End If
  
  Call tbs_Filter_Click
  
  If Not mo_BOM Is Nothing Then
    Call mo_Tools.SetTextValue(txt_Textbox, "txt_IdentNr", mo_BOM.BOM_IdentNr)
    If mo_BOM.BOM_IdentNr <> "" Then
      Call RefreshGrid
    End If
  End If
  mb_Result = False
  mb_Initialized = True
  Load_A_COM = mb_Initialized
  Exit Function
ErrHandler:
  Call ErrorMessage("Load_A_COM")
End Function

Private Function GetRawMaterialFilter() As eDPCBOMMaterial
On Error GoTo ErrHandler

  Select Case tbs_Filter.SelectedItem.Key
  Case "tbs_All"
    GetRawMaterialFilter = eDPCBOMMaterial.bcNone
  Case "tbs_Coil"
    GetRawMaterialFilter = eDPCBOMMaterial.bcCoil
  Case "tbs_SheetMetal"
    GetRawMaterialFilter = eDPCBOMMaterial.bcSheetMetal
  Case "tbs_Coating"
    GetRawMaterialFilter = eDPCBOMMaterial.bcCoating
  Case "tbs_Inlay"
    GetRawMaterialFilter = eDPCBOMMaterial.bcInlay
  Case "tbs_Gasket"
    GetRawMaterialFilter = eDPCBOMMaterial.bcGasket
  Case "tbs_Packaging"
    GetRawMaterialFilter = eDPCBOMMaterial.bcPacking
  Case Else
  End Select
  Exit Function
ErrHandler:
  Call ErrorMessage("GetRawMaterialFilter")
End Function

Public Function Unload_A_COM() As Boolean
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Sys = Nothing
  Set mo_FSO = Nothing
  Set mo_Db = Nothing
  Exit Function
ErrHandler:
  Call ErrorMessage("Unload_A_COM")
End Function

Private Sub Resize()
On Error GoTo ErrHandler

  Call fra_FilterMain.Move(0, tbs_Filter.Top + tbs_Filter.Height, Me.Width, grd_Material.Top - (tbs_Filter.Top + tbs_Filter.Height))
  Exit Sub
ErrHandler:
    Call ErrorMessage("Resize")
End Sub

Private Sub grd_Material_Click()
On Error GoTo ErrHandler

  Call mo_Tools.LockScreen(Me, True)
  ms_IdentNr = ""
  ms_IdentName = ""
  If grd_Material.SelectedCount = 1 Then
    ms_IdentNr = grd_Material.SelectedLine(0, "identnr")
    ms_IdentName = grd_Material.SelectedLine(0, "ben")
  End If
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
    Call ErrorMessage("grd_Material_Click")
End Sub

Private Sub grd_Material_ItemSelected()
On Error GoTo ErrHandler

  Call tlb_Main_action("H", ms_Language_Code)
  Exit Sub
ErrHandler:
    Call ErrorMessage("grd_Material_ItemSelected")
End Sub

Private Sub tbs_Filter_Click()
On Error GoTo ErrHandler

Dim ll_Idx As Long
Dim le_MaterialType As eDPCBOMMaterial

  le_MaterialType = GetRawMaterialFilter
  
  For ll_Idx = 0 To fra_Filter.Count - 1
    fra_Filter(ll_Idx).Visible = (le_MaterialType = eDPCBOMMaterial.bcNone)
  Next
  
  'show/hide grid columns
  If (le_MaterialType = eDPCBOMMaterial.bcNone) Or (le_MaterialType = eDPCBOMMaterial.bcInlay) Then
    grd_Material.Columns("InlayCode").Width = mla_OrigColWidth(grd_Material.Columns("InlayCode").ColumnIndex)
  Else
    grd_Material.Columns("InlayCode").Width = 0
  End If
  
  If (le_MaterialType = eDPCBOMMaterial.bcNone) Or (le_MaterialType = eDPCBOMMaterial.bcCoating) Then
    grd_Material.Columns("norm").Width = mla_OrigColWidth(grd_Material.Columns("norm").ColumnIndex)
    grd_Material.Columns("klasse").Width = mla_OrigColWidth(grd_Material.Columns("klasse").ColumnIndex)
  Else
    grd_Material.Columns("norm").Width = 0
    grd_Material.Columns("klasse").Width = 0
  End If
  
  If (le_MaterialType = eDPCBOMMaterial.bcNone) Or (le_MaterialType = eDPCBOMMaterial.bcCoil) Then
    grd_Material.Columns("StandardCoil").Width = mla_OrigColWidth(grd_Material.Columns("StandardCoil").ColumnIndex)
  Else
    grd_Material.Columns("StandardCoil").Width = 0
  End If
  
  'show hide filters
  If (le_MaterialType = eDPCBOMMaterial.bcCoil) Or (le_MaterialType = eDPCBOMMaterial.bcSheetMetal) Then
    mo_Tools.GetControl(fra_Filter, "fra_FilterCoil").Visible = True
    mo_Tools.GetControl(fra_Filter, "fra_FilterWidth").Visible = True
    mo_Tools.GetControl(fra_Filter, "fra_FilterLagerbest").Visible = True
  End If
  
  If (le_MaterialType = eDPCBOMMaterial.bcCoating) Then
    mo_Tools.GetControl(fra_Filter, "fra_FilterCoating").Visible = True
    mo_Tools.GetControl(fra_Filter, "fra_FilterLagerbest").Visible = True
  End If
  
  If (le_MaterialType = eDPCBOMMaterial.bcInlay) Then
    mo_Tools.GetControl(fra_Filter, "fra_FilterWidth").Visible = True
    mo_Tools.GetControl(fra_Filter, "fra_FilterLength").Visible = True
    mo_Tools.GetControl(fra_Filter, "fra_FilterInlayCode").Visible = True
    mo_Tools.GetControl(fra_Filter, "fra_FilterLagerbest").Visible = True
  End If
  
  If (le_MaterialType = eDPCBOMMaterial.bcSpacer) Or (le_MaterialType = eDPCBOMMaterial.bcGasket) Then
  End If
  
  If (le_MaterialType = eDPCBOMMaterial.bcPacking) Then
    mo_Tools.GetControl(fra_Filter, "fra_FilterLagerbest").Visible = True
  End If
  Exit Sub
ErrHandler:
    Call ErrorMessage("tbs_Filter_Click")
End Sub

Private Sub txt_Textbox_KeyPress(Index As Integer, KeyAscii As Integer)
On Error GoTo ErrHandler
  
  Call mo_Tools.LockScreen(Me, True)
  If KeyAscii = 13 Then
    Call RefreshGrid
  End If
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("txt_Textbox_KeyPress")
End Sub

Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler

  Call mo_Tools.LockScreen(Me, True)
  Select Case as_Role
  Case "H"
    If ms_IdentNr = "" Then
      Call mo_Tools.LockScreen(Me, False)
      Exit Sub
    End If
    mb_Result = True
    Hide
  Case "L"
    Call RefreshGrid
  Case "T"
    mb_Result = False
    Hide
  End Select
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("tlb_Main_action")
End Sub

Private Function ReplaceFilter(ByVal ae_MaterialType As eDPCBOMMaterial, ByVal as_req As String) As String
On Error GoTo ErrHandler
  
Dim ll_CoaTypeIdx As Long
Dim ll_CoaNormIdx As Long
Dim ll_CoaAppIdx As Long
  
  
  If mo_Tools.GetControl(fra_Filter, "fra_FilterArticleGroup").Visible Then
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_ArticleGroup")) <> "" Then
      as_req = Replace(as_req, "$agnr$", mo_Tools.SqlInt(mo_Tools.ScreenToLong(mo_Tools.GetTextValue(txt_Textbox, "txt_ArticleGroup"))), , , vbTextCompare)
    End If
  End If
  
  If ae_MaterialType = eDPCBOMMaterial.bcCoil Then
    as_req = Replace(as_req, "$agr$", "IN (10,20,40,60,80,99,110,130,160,170,180)", , , vbTextCompare)
  ElseIf ae_MaterialType = eDPCBOMMaterial.bcSheetMetal Then
    as_req = Replace(as_req, "$agr$", "IN (30,50,70,90,120,140)", , , vbTextCompare)
  ElseIf ae_MaterialType = eDPCBOMMaterial.bcInlay Then
    as_req = Replace(as_req, "$agr$", "IN (250,260,270)", , , vbTextCompare)
  ElseIf (ae_MaterialType = eDPCBOMMaterial.bcGasket) Or (ae_MaterialType = eDPCBOMMaterial.bcSpacer) Then
    as_req = Replace(as_req, "$agr$", "IN (240,241)", , , vbTextCompare)
  Else
    If mo_Tools.GetControl(fra_Filter, "fra_FilterCoating").Visible Then
      ll_CoaTypeIdx = mo_Tools.WhichOptionIsTrue(opt_CoatingType)
      If ll_CoaTypeIdx = 0 Then
        If ae_MaterialType = eDPCBOMMaterial.bcCoating Then
          as_req = Replace(as_req, "$agr$", "IN (210,211,220)", , , vbTextCompare)
        Else
          as_req = Replace(as_req, "$agr$", ">=0", , , vbTextCompare)
        End If
      ElseIf ll_CoaTypeIdx = 1 Then
        as_req = Replace(as_req, "$agr$", "= 210", , , vbTextCompare)
      ElseIf ll_CoaTypeIdx = 2 Then
        as_req = Replace(as_req, "$agr$", "= 211", , , vbTextCompare)
      ElseIf ll_CoaTypeIdx = 3 Then
        as_req = Replace(as_req, "$agr$", "= 220", , , vbTextCompare)
      End If
    Else
      as_req = Replace(as_req, "$agr$", ">=0", , , vbTextCompare)
    End If
  End If
  
  If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_IdentNr")) = "" Then
    as_req = Replace(as_req, "$identnr$", "NULL", , , vbTextCompare)
  Else
    as_req = Replace(as_req, "$identnr$", mo_Tools.SQLStr("%" & mo_Tools.GetTextValue(txt_Textbox, "txt_IdentNr") & "%") & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
  End If
  
  If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_Name")) = "" Then
    as_req = Replace(as_req, "$ben$", "NULL", , , vbTextCompare)
  Else
    as_req = Replace(as_req, "$ben$", mo_Tools.SQLStr("%" & mo_Tools.GetTextValue(txt_Textbox, "txt_Name") & "%") & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
  End If
  
  If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_Desc")) = "" Then
    as_req = Replace(as_req, "$ben1$", "NULL", , , vbTextCompare)
  Else
    as_req = Replace(as_req, "$ben1$", mo_Tools.SQLStr("%" & mo_Tools.GetTextValue(txt_Textbox, "txt_Desc") & "%") & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
  End If
    
  If mo_Tools.GetControl(fra_Filter, "fra_FilterCoil").Visible Then
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_CoilMaterial")) = "" Then
      as_req = Replace(as_req, "$werkstoff$", "NULL", , , vbTextCompare)
    Else
      as_req = Replace(as_req, "$werkstoff$", mo_Tools.SQLStr("%" & mo_Tools.GetTextValue(txt_Textbox, "txt_CoilMaterial") & "%") & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
    End If
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_CoilThickness")) = "" Then
      as_req = Replace(as_req, "$thickness$", "NULL", , , vbTextCompare)
    Else
      as_req = Replace(as_req, "$thickness$", mo_Tools.SqlDbl(mo_Tools.ScreenToDbl(mo_Tools.GetTextValue(txt_Textbox, "txt_CoilThickness"))), , , vbTextCompare)
    End If
  Else
    as_req = Replace(as_req, "$werkstoff$", "NULL", , , vbTextCompare)
    as_req = Replace(as_req, "$thickness$", "NULL", , , vbTextCompare)
  End If
  
  If mo_Tools.GetControl(fra_Filter, "fra_FilterLagerbest").Visible Then
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_Lagerbest")) = "" Then
      as_req = Replace(as_req, "$lamenge$", "NULL", , , vbTextCompare)
    Else
      as_req = Replace(as_req, "$lamenge$", mo_Tools.SqlDbl(mo_Tools.ScreenToDbl(mo_Tools.GetTextValue(txt_Textbox, "txt_Lagerbest"))), , , vbTextCompare)
    End If
  Else
    as_req = Replace(as_req, "$lamenge$", "NULL", , , vbTextCompare)
  End If
  
  If mo_Tools.GetControl(fra_Filter, "fra_FilterInlayCode").Visible Then
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_InlayCode")) = "" Then
      as_req = Replace(as_req, "$inlaycode$", "NULL", , , vbTextCompare)
    Else
      as_req = Replace(as_req, "$inlaycode$", mo_Tools.SQLStr(mo_Tools.GetTextValue(txt_Textbox, "txt_InlayCode")), , , vbTextCompare)
    End If
  Else
    as_req = Replace(as_req, "$inlaycode$", "NULL", , , vbTextCompare)
  End If
  
  
  If mo_Tools.GetControl(fra_Filter, "fra_FilterLength").Visible Then
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_Length")) = "" Then
      as_req = Replace(as_req, "$length$", "NULL", , , vbTextCompare)
    Else
      as_req = Replace(as_req, "$length$", mo_Tools.SqlDbl(mo_Tools.ScreenToDbl(mo_Tools.GetTextValue(txt_Textbox, "txt_Length"))), , , vbTextCompare)
    End If
  Else
    as_req = Replace(as_req, "$length$", "NULL", , , vbTextCompare)
  End If
  
  If mo_Tools.GetControl(fra_Filter, "fra_FilterWidth").Visible Then
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_Width")) = "" Then
      as_req = Replace(as_req, "$width$", "NULL", , , vbTextCompare)
    Else
      as_req = Replace(as_req, "$width$", mo_Tools.SqlDbl(mo_Tools.ScreenToDbl(mo_Tools.GetTextValue(txt_Textbox, "txt_Width"))), , , vbTextCompare)
    End If
  Else
    as_req = Replace(as_req, "$width$", "NULL", , , vbTextCompare)
  End If
  
  If mo_Tools.GetControl(fra_Filter, "fra_FilterCoating").Visible Then
    ll_CoaNormIdx = mo_Tools.WhichOptionIsTrue(opt_ColorNorm)
    If ll_CoaNormIdx = eDPCColorNorm.cnUndef Then
      as_req = Replace(as_req, "$norm$", "NULL", , , vbTextCompare)
    ElseIf ll_CoaNormIdx = eDPCColorNorm.cnRAL Then
      as_req = Replace(as_req, "$norm$", mo_Tools.SQLStr(DPC_BAEURER_COLOR_NORM_RAL) & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
    ElseIf ll_CoaNormIdx = eDPCColorNorm.cnNCS Then
      as_req = Replace(as_req, "$norm$", mo_Tools.SQLStr(DPC_BAEURER_COLOR_NORM_NCS) & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
    End If
    
    ll_CoaAppIdx = mo_Tools.WhichOptionIsTrue(opt_CoatingApp)
    If ll_CoaAppIdx = eDPCCoatingApplication.caUndef Then
      as_req = Replace(as_req, "$klasse$", "NULL", , , vbTextCompare)
    ElseIf ll_CoaAppIdx = eDPCCoatingApplication.ceInside Then
      as_req = Replace(as_req, "$klasse$", mo_Tools.SQLStr(DPC_BAEURER_COATING_APP_INSIDE) & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
    ElseIf ll_CoaAppIdx = eDPCCoatingApplication.ceOutside Then
      as_req = Replace(as_req, "$klasse$", mo_Tools.SQLStr(DPC_BAEURER_COATING_APP_OUTSIDE) & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
    End If
    
    If Trim(mo_Tools.GetTextValue(txt_Textbox, "txt_CoatingNormNr")) = "" Then
      as_req = Replace(as_req, "$normnr$", "NULL", , , vbTextCompare)
    Else
      as_req = Replace(as_req, "$normnr$", mo_Tools.SQLStr("%" & mo_Tools.GetTextValue(txt_Textbox, "txt_CoatingNormNr") & "%") & " COLLATE Latin1_General_CI_AS ", , , vbTextCompare)
    End If
  Else
    as_req = Replace(as_req, "$norm$", "NULL", , , vbTextCompare)
    as_req = Replace(as_req, "$klasse$", "NULL", , , vbTextCompare)
    as_req = Replace(as_req, "$normnr$", "NULL", , , vbTextCompare)
  End If
  ReplaceFilter = as_req
  Exit Function
ErrHandler:
  Call ErrorMessage("ReplaceFilter")
End Function

Private Sub RefreshGrid()
On Error GoTo ErrHandler

Dim ls_req As String
Dim le_MaterialType As eDPCBOMMaterial
  
  le_MaterialType = GetRawMaterialFilter
  ms_IdentNr = ""
  ms_IdentName = ""

  ls_req = "SELECT TOP 100 g000.identnr, g0402.ben, g0402.ben1, g000.me, g0402.werkstoff, g0402.klasse, g0402.norm, g0402.normnr,"
  ls_req = ls_req & "ROUND(g711Length.ausprfloat,2) as Length, ROUND(g711Width.ausprfloat,2) as Width, ROUND(g711Thick.ausprfloat,2) as Thickness,"
  ls_req = ls_req & "g711Inlay.ausprtxt AS InlayCode,g711StdCoil.ausprtxt as StandardCoil,"
  ls_req = ls_req & "l020.lamenge,g020.bestell,g020.vormerk,l020.lamenge + g020.bestell - g020.vormerk as verfugbar, "
  ls_req = ls_req & "(SELECT TOP 1 ekpreis "
  ls_req = ls_req & "FROM e025 "
  ls_req = ls_req & "WHERE "
  ls_req = ls_req & "(e025.fi_nr = $fi_nr$ OR e025.fi_nr=0) AND "
  ls_req = ls_req & "(e025.identnr = g000.identnr) AND "
  ls_req = ls_req & "(e025.datvon <= $date$ AND ($date$ < DATEADD(day, 1,e025.datbis) OR e025.datbis IS NULL)) AND "
  ls_req = ls_req & "(e025.menge_ab <= $qty$) AND "
  ls_req = ls_req & "(e025.pr_herk_e = 'A') "
  ls_req = ls_req & "ORDER BY menge_ab DESC) AS Price "
  ls_req = ls_req & "FROM g000 "
  ls_req = ls_req & "LEFT JOIN g040 ON (g000.fi_nr = g040.fi_nr AND g000.identnr = g040.identnr ) "
  ls_req = ls_req & "LEFT JOIN g0402 ON (g000.fi_nr = g0402.fi_nr AND g000.identnr = g0402.identnr and g0402.lang_ext =$lang_ext$) "
  ls_req = ls_req & "LEFT JOIN g730 as g730Length ON (g730Length.fldname='LAENGEA' and g730Length.fi_nr = $fi_nr$) "
  ls_req = ls_req & "LEFT JOIN g711 as g711Length ON (g000.objektid = g711Length.objektid and g711Length.kritnr = g730Length.kritnr) "
  ls_req = ls_req & "LEFT JOIN g730 as g730Width ON (g730Width.fldname='BREITEB' and g730Width.fi_nr = $fi_nr$) "
  ls_req = ls_req & "LEFT JOIN g711 as g711Width ON (g000.objektid = g711Width.objektid and g711Width.kritnr = g730Width.kritnr) "
  ls_req = ls_req & "LEFT JOIN g730 as g730Thick ON (g730Thick.fldname='MATDICKE' and g730Thick.fi_nr = $fi_nr$) "
  ls_req = ls_req & "LEFT JOIN g711 as g711Thick ON (g000.objektid = g711Thick.objektid and g711Thick.kritnr = g730Thick.kritnr) "
  ls_req = ls_req & "LEFT JOIN g730 as g730Inlay ON (g730Inlay.fldname='AKUSTEINL' and g730Inlay.fi_nr = $fi_nr$) "
  ls_req = ls_req & "LEFT JOIN g711 as g711Inlay ON (g000.objektid = g711Inlay.objektid and g711Inlay.kritnr = g730Inlay.kritnr) "
  ls_req = ls_req & "LEFT JOIN g730 as g730StdCoil ON (g730StdCoil.fldname='STANDARDCOIL' and g730StdCoil.fi_nr = $fi_nr$) "
  ls_req = ls_req & "LEFT JOIN g711 as g711StdCoil ON (g000.objektid = g711StdCoil.objektid and g711StdCoil.kritnr = g730StdCoil.kritnr) "
  ls_req = ls_req & "LEFT JOIN g001 ON (g000.fi_nr = g001.fi_nr AND g000.identnr = g001.identnr) "
  ls_req = ls_req & "LEFT JOIN g023 ON (g000.fi_nr = g023.fi_nr AND g000.identnr = g023.identnr) "
  ls_req = ls_req & "LEFT JOIN g030 on (g000.fi_nr = g030.fi_nr AND g000.identnr = g030.identnr) "
  ls_req = ls_req & "LEFT JOIN g043 on (g000.fi_nr = g043.fi_nr AND g000.identnr = g043.identnr) "
  ls_req = ls_req & "LEFT JOIN l020 on (g000.fi_nr = l020.fi_nr AND l020.lgnr=$lgnr$ AND g000.identnr = l020.identnr) "
  ls_req = ls_req & "LEFT JOIN g020 on (g000.fi_nr = g020.fi_nr AND g020.lgnr=$lgnr$ AND g000.identnr = g020.identnr) "
  ls_req = ls_req & "WHERE (g000.fi_nr= $fi_nr$) AND "
  ls_req = ls_req & "(g040.ts = 1) AND "
  ls_req = ls_req & "(g0402.ben LIKE $ben$ OR $ben$ IS NULL) AND "
  ls_req = ls_req & "(g0402.ben1 LIKE $ben1$ OR $ben1$ IS NULL) AND "
  ls_req = ls_req & "(g0402.werkstoff LIKE $werkstoff$ OR $werkstoff$ IS NULL) AND "
  ls_req = ls_req & "(g000.identnr LIKE $identnr$ OR $identnr$ IS NULL) AND "
  ls_req = ls_req & "(g043.agr $agr$) AND "
  ls_req = ls_req & "(l020.lamenge >= $lamenge$ OR $lamenge$ IS NULL) AND "
  ls_req = ls_req & "(ROUND(ISNULL(g711Length.ausprfloat,0),2) = $length$ OR $length$ IS NULL) AND "
  ls_req = ls_req & "(ROUND(ISNULL(g711Width.ausprfloat,0),2) = $width$ OR $width$ IS NULL) AND "
  ls_req = ls_req & "(ROUND(ISNULL(g711Thick.ausprfloat,0),2) = $thickness$ OR $thickness$ IS NULL) AND "
  ls_req = ls_req & "(ISNULL(g711Inlay.ausprtxt,'') = $InlayCode$ OR $InlayCode$ IS NULL) AND "
  ls_req = ls_req & "(g0402.klasse = $klasse$ OR $klasse$ IS NULL) AND "
  ls_req = ls_req & "(g0402.norm = $norm$ OR $norm$ IS NULL) AND "
  ls_req = ls_req & "(g0402.normnr LIKE $normnr$ OR $normnr$ IS NULL) "
  ls_req = ls_req & "ORDER BY g000.identnr"
  
  ls_req = Replace(ls_req, "$lang_ext$", mo_Tools.SQLStr("de_de"), , , vbTextCompare)
  ls_req = Replace(ls_req, "$fi_nr$", mo_Tools.SqlInt(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$date$", mo_Tools.SqlDate(Date), , , vbTextCompare)
  ls_req = Replace(ls_req, "$qty$", mo_Tools.SqlDbl(1), , , vbTextCompare)
  ls_req = Replace(ls_req, "$lgnr$", mo_Tools.SqlInt(0), , , vbTextCompare)
  ls_req = ReplaceFilter(le_MaterialType, ls_req)
  If Not grd_Material.Load(ls_req, True) Then
    Err.Raise ArmErr.CompFncFailed, "grd_Material.Load", "Grid load failed: " & ls_req
  End If
  Exit Sub
ErrHandler:
  Call ErrorHandler("RefreshGrid")
End Sub

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub

